/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum CampfireProvider implements IServerExtensionProvider<Object, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_CAMPFIRE;
    }

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, stack -> {
            String text = null;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("jade:cooking")) {
                text = IThemeHelper.get().seconds(stack.m_41783_().m_128451_("jade:cooking")).getString();
            }
            return new ItemView((ItemStack)stack, text);
        }, null);
    }

    @Override
    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer player, ServerLevel world, Object target, boolean showDetails) {
        if (target instanceof CampfireBlockEntity) {
            CampfireBlockEntity campfire = (CampfireBlockEntity)target;
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < campfire.f_59044_.length; ++i) {
                ItemStack stack = (ItemStack)campfire.m_59065_().get(i);
                if (stack.m_41619_()) continue;
                stack = stack.m_41777_();
                stack.m_41784_().m_128405_("jade:cooking", campfire.f_59044_[i] - campfire.f_59043_[i]);
                list.add(stack);
            }
            return List.of(new ViewGroup(list));
        }
        return null;
    }
}

